function [Aproj_raw]=mzPCA_raw(rawdata);  
%This program will take your raw data and perform PCA.  It will calculate
%all the principal components but only give out scores.  This command
%automatically mean-centers the data.

%INPUTS
%rawdata - this is your data of all pixels. The number of rows should
%equal the number of pixels and the number of columns should equal the
%number of m/z values in each scan, remembering that the data may be
%trimmed and/or Gaussian smoothed and/or downsampled.

%OUTPUTS
%Aproj_raw - Scores of the principal components for each pixel. The number 
%of rows has some number of principal components calculated (20 for easy
%viewing, see below) and the number of columns equals the number of pixels.
%The first row corresponds to the scores for the principal component and so
%on.

%By default, this only outputs the first 20 PCs. Some or all of
%these principal components may be relevant. If you wish to change this to
%a higher number to include more principal components (in case 20 is not
%enough)change the number 20 in command line 38 below.

%The commands below mean center the data prior to PCA:
meandata=mean(rawdata);

[a,b]=size(rawdata);
for x=1:a
    rawdata(x,:)=rawdata(x,:)-meandata;
end
clear a b

%The svd command actually performs PCA:
[u,s,v]=svd(rawdata');
%the next command extracts the spectral trends.  By default, I choose 20.
%If you want/need more, feel free to change the number 20 to whatever you
%wish in the command line below:
Vc=u(:,(1:20));

% The next command line allows me to generate scores:
Aproj_raw=Vc'*rawdata';


